<?php
/**
 * Selins Theme functions
 */

if ( ! defined('ABSPATH') ) { exit; }

// 1) CSS/JS enqueue
add_action('wp_enqueue_scripts', function () {

  // Ana stil dosyası
  wp_enqueue_style(
    'selins-main',
    get_template_directory_uri() . '/assets/css/main.css',
    [],
    '1.0'
  );

  // Ana JS dosyası
  wp_enqueue_script(
    'selins-main',
    get_template_directory_uri() . '/assets/js/main.js',
    [],
    '1.0',
    true
  );
});

// 2) Tema destekleri (SEO/kurumsal için temel)
add_action('after_setup_theme', function () {
  add_theme_support('title-tag');         // <title> otomatik
  add_theme_support('post-thumbnails');   // öne çıkan görsel
  add_theme_support('html5', ['search-form','comment-form','comment-list','gallery','caption','style','script']);
});

// 3) Menü alanları
add_action('after_setup_theme', function () {
  register_nav_menus([
    'primary' => 'Üst Menü',
    'footer'  => 'Alt Menü'
  ]);
});
